/**********************************************************************
*
* autolaunch event.c -- Version 3.0
*
* Copyright (c)
* Apple Computer, Inc.  1988-1990
* All Rights Reserved.
*
* Written by Eric Soldan.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements the 
* main event loop used by the autolaunch program.
*
**********************************************************************/

#include <types.h>
#include <event.h>
#include <font.h>
#include <intmath.h>
#include <lineedit.h>
#include <locator.h>
#include <menu.h>
#include <resources.h>
#include <window.h>

#include "autolaunch.h"

void			i2pstr();
void			mainWindowDraw();
unsigned int	validLEKey();
void			updateControls();
void			updateLaunchTimer();
void			doNetCheck();

/**********************************************************************
*
* mainEvent
*
* This is the main part of the program.  The program cycles in this
* loop until the user chooses quit.
*
**********************************************************************/

void	mainEvent()
{
	WindowPtr		wptr, keepPort;
	unsigned long	id;
	unsigned int	item;
	char			pstr[16];

	zapLocals();

	getLaunchInfo();		/* Load the launch configuration from disk. */

	keepPort = GetPort();

	wptr = NewWindow2(NULL, NULL, NULL, NULL, 2, MainWindowID, rWindParam1);
	if (!_toolErr) {
		mainWindow = wptr;

		updateControls();
		i2pstr(pstr, launch.timer);
		fmdLESetText(mainWindow, AppTimerData, pstr);

		ShowWindow(wptr);		/* Now that everything is okay, show window. */
		SelectWindow(wptr);

		doNetCheck(1);			/* Initialize the network checking. */
		for (;;) {

			doNetCheck(0);
			if (quitFlag) break;

			id = fakeModalDialog(&event, mainWindowDraw, handleKeys, NULL,
				fmdMenuSelect+
				fmdMenuKey+
				fmdIBeam+
				fmdDeskAcc+
				fmdUpdateAll+
				fmdMovable
			);
			item = id;
			if (id & 0x80000000L) {		/* Hi-bit on?  It's a menu command. */
				doMenuCommand(id);
				if (quitFlag) break;	/* It was a quit menu command. */
			}
			else {
				switch (item) {			/* User clicked on ctl -- handle it. */
					case AppLaunch:
					quitFlag = 2;		/* User said launch, so do it. */
					break;
				}
				if (quitFlag) break;
					/* User chose quit while tabs window was up. */
			}
		}

		SetPort(keepPort);
		CloseWindow(wptr);
		mainWindow = NULL;
	}
}

/**********************************************************************/

pascal void		handleKeys(event)
WmTaskRec*		event;
{
	unsigned int	c, e, m;

	c = event->message & 0xFF;
	e = event->what;
	m = event->modifiers & (appleKey | shiftKey | optionKey | controlKey);

	if ((e == keyDownEvt) || (e == autoKeyEvt)) {
		if (validLEKey(c, m)) return;
		if ((c < '0') || (c > '9')) event->what = 0;
	}
}

/**********************************************************************/

unsigned int	validLEKey(c, m)
unsigned int	c, m;
{
	unsigned int	i, j;

	static char		validChrs[] = {
		6,		/* Allow char-right-of-cursor delete. */
		8,		/* Allow left arrow. */
		9,		/* Allow tab key. */
		13,		/* Allow default button. */
		21,		/* Allow right arrow. */
		24,		/* Allow ctrl-x to clear field. */
		25,		/* Allow delete to end-of-line. */
		127,	/* Allow delete. */
		0		/* End of list. */
	};			/* These are the valid lineEdit editing keys.  Allow them. */

	if (m & appleKey) return(1);		/* Allow command keys. */

	c &= 0xFF;							/* Just to be sure.    */

			for (i = 0; j = validChrs[i]; i++) if (c == j) return(1);
		/* If it is a valid editLine editing character, allow it. */

	return(0);
}

/**********************************************************************/

void	mainWindowDraw()
{
	fmdStdDrawProc();
}

/**********************************************************************/

void	updateControls()
{
	CtlRecPtr		ctlPtr;
	unsigned int	*iptr, v, hilite;
	char			*cptr;

	hilite = 0;

	ctlPtr = *GetCtlHandleFromID(mainWindow, AppTriggerData);
	iptr = (unsigned int *)launch.triggerName;
	cptr = launch.triggerName + 2;
	if (!*iptr) {
		++*iptr;
		*cptr = ' ';
	}
	ctlPtr->ctlValue = *iptr;
	ctlPtr->ctlData  = (unsigned long)cptr;
	if ((*iptr == 1) && (*cptr == ' ')) hilite = 255;

	ctlPtr = *GetCtlHandleFromID(mainWindow, AppTargetData);
	iptr = (unsigned int *)launch.targetName;
	cptr = launch.targetName + 2;
	if (!*iptr) {
		++*iptr;
		*cptr = ' ';
	}
	ctlPtr->ctlValue = *iptr;
	ctlPtr->ctlData  = (unsigned long)cptr;
	if ((*iptr == 1) && (*cptr == ' ')) hilite = 255;

	HiliteControl(hilite, GetCtlHandleFromID(mainWindow, AppLaunch));
}

/**********************************************************************/

void	updateLaunchTimer()
{
	char	pstr[16];

	fmdLEGetText(mainWindow, AppTimerData, pstr);
	launch.timer = pstr2i(pstr);
	if (!launch.timer) launch.timer++;
}

